﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.OptionSets;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelInbound
{
    /// <summary>
    /// Get Patient Id step.
    /// </summary>
    public class GetPatientIdStep : FilterBase<MakeCancelInboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelInboundStateObject state)
        {
            using (var svc = new Xrm(state.OrganizationServiceProxy))
            {
                var patientIdentifier = svc.mcs_personidentifiersSet.FirstOrDefault(x =>
                    x.mcs_identifiertype.Value == (int)mcs_personidentifiersmcs_identifiertype.NationalIdentifier_NI &&
                    x.mcs_assigningauthority == "USVHA" &&
                    x.mcs_identifier == state.OutboundEcRequestMessage.PatientIcn);

                if (patientIdentifier == null) throw new Exception($"Patient ICN not found for {state.OutboundEcRequestMessage.PatientIcn}");

                state.PatientId = patientIdentifier.mcs_patient.Id;
            }
        }
    }
}